/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.auiml.databeans.ucode.RepositoryItem;
import com.ibm.hsc.ccfw.mom.PICec;
import com.ibm.hsc.client.PIHMCStringDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.command.HMCCommandsTask;
import com.ibm.hsc.command.PICmdOutputUtils;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.command.PIUpdLic;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.websm.updates.PIUpdateableComponent;
import com.ibm.hsc.websm.updates.PIUpdater;
import com.ibm.hsc.websm.updates.PIUpdatesOwner;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtil;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;

public class PILsLic
extends HMCCommandsTask {
    private static final String TRACE_MASKD = "JCLSLICD";
    private static final String TRACE_MASKF = "JCLSLICF";
    private static final String TRACE_MASKT = "JCLSLICT";
    private static final String CPC_PARAM = "cpc";
    private static final String SYS_PARAM = "sys";
    private static final String POWER_PARAM = "power";
    private static final String CPCPOWER_PARAM = "cpcpower";
    private static final String SYSPOWER_PARAM = "syspower";
    private static final String RETAIN_PARAM = "ibmretain";
    private static final String WEBSITE_PARAM = "ibmwebsite";
    private static final String FTP_PARAM = "ftp";
    private static final String DVD_PARAM = "dvd";
    private static final String DISK_PARAM = "disk";
    private static final String MOUNTPOINT_PARAM = "mountpoint";
    private static final String LIC_TYPE_FORMAT = "lic_type";
    private static final String MGMT_STATUS_FORMAT = "management_status";
    private static final String REASON_FORMAT = "disabled_reason";
    private static final String ACT_LEVEL_FORMAT = "activated_level";
    private static final String INST_LEVEL_FORMAT = "installed_level";
    private static final String ACCEPTED_LEVEL_FORMAT = "accepted_level";
    private static final String ECNUMBER_FORMAT = "ecnumber";
    private static final String CONC_RETR_LEVEL_FORMAT = "concurrent_retrievable_level";
    private static final String DISR_RETR_LEVEL_FORMAT = "disruptive_retrievable_level";
    private static final String MTMS_FORMAT = "mtms";
    private static final String[] noReposKeys = new String[]{"lic_type", "management_status", "disabled_reason", "activated_level", "installed_level", "accepted_level", "ecnumber", "mtms"};
    private static final String[] reposKeys = new String[]{"lic_type", "management_status", "disabled_reason", "activated_level", "installed_level", "accepted_level", "ecnumber", "concurrent_retrievable_level", "disruptive_retrievable_level", "mtms"};
    private static final String[] FTP_PARAMS = new String[]{"-h", "-u", "-d", "--passwd"};
    private String[] validKeys;
    private String[] actualKeys;
    private String password;
    private String hostname;
    private String username;
    private String directory;
    private int reposType;
    private boolean targetCEC;
    private boolean targetPower;
    private boolean checkRepos;
    private boolean mountpoint;
    private String managedSystem;
    private PIHSCCECClient hcc;
    private PIUpdatesOwner updatesOwner;
    private List compList;
    private static final int NUM_VALID_PARMS = 9;
    private HashMap m_validParms = new HashMap(19, 0.5f);
    private boolean m_header = false;
    private String m_delimiter = ",";
    private String m_format = null;

    private PILsLic() {
        this.m_validParms.put("-m", null);
        this.m_validParms.put("-t", null);
        this.m_validParms.put("-r", null);
        this.m_validParms.put("-h", null);
        this.m_validParms.put("-u", null);
        this.m_validParms.put("--passwd", null);
        this.m_validParms.put("-d", null);
        this.m_validParms.put("-F", null);
        this.m_validParms.put("--header", null);
    }

    private void initializeClients() throws UnknownHostException, PIHscClientException {
        PIHSCClientObjectFactory pIHSCClientObjectFactory = null;
        String string = null;
        string = InetAddress.getLocalHost().getHostName();
        pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string, null);
        this.hcc = pIHSCClientObjectFactory.createCECClient(this.managedSystem, false);
        if (null == this.hcc) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MANAGED_SYSTEM_NOT_FOUND");
        }
    }

    private void readPassword(PrintStream printStream) throws PIHscClientException {
        try {
            EExecResult eExecResult;
            String string = System.getProperty("HMCtty.name");
            String string2 = null;
            String string3 = null;
            boolean bl = false;
            if (string != null && string != "") {
                eExecResult = EExec.Exec((String)("stty --save --file=" + string));
                string2 = "stty --file=" + string + " " + eExecResult.stdout;
                string3 = "stty --file=" + string + " -echo";
                bl = true;
            }
            Object[] objectArray = new String[]{this.username};
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "ENTER_OLD_PASSWORD", null, objectArray));
            if (bl) {
                eExecResult = EExec.Exec(string3);
            }
            this.password = bufferedReader.readLine().trim();
            if (bl) {
                eExecResult = EExec.Exec((String)string2);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "ERROR_READING_PASSWORD");
        }
    }

    private void checkLIC(String string) throws PIHscClientException {
        for (int i = 0; i < this.compList.size(); ++i) {
            PIUpdateableComponent pIUpdateableComponent = (PIUpdateableComponent)this.compList.get(i);
            String string2 = pIUpdateableComponent.getName();
            String string3 = pIUpdateableComponent.getECNumber();
            String string4 = pIUpdateableComponent.getMTMS();
            int n = pIUpdateableComponent.getAppliedLevel();
            int n2 = pIUpdateableComponent.getApplyInProgressLevel();
            int n3 = pIUpdateableComponent.getCommittedLevel();
            int n4 = pIUpdateableComponent.getNonDisruptiveStagableLevel();
            int n5 = pIUpdateableComponent.getStagableLevel();
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Component name            <" + string2 + ">");
                Trace.trace(TRACE_MASKF, "ECNumber                  <" + string3 + ">");
                Trace.trace(TRACE_MASKF, "MTMS                      <" + string4 + ">");
                Trace.trace(TRACE_MASKF, "Activated level           " + n);
                Trace.trace(TRACE_MASKF, "Installed level           " + n2);
                Trace.trace(TRACE_MASKF, "Accepted level            " + n3);
                if (this.checkRepos) {
                    Trace.trace(TRACE_MASKF, "Concurrent stagable level " + n4);
                    Trace.trace(TRACE_MASKF, "Disruptive stagable level " + n5);
                }
            }
            if (!string2.equals(string)) continue;
            if (this.checkRepos && (this.reposType == 5 || this.reposType == 0 || this.reposType == 4) && !pIUpdateableComponent.isRemoteSupportSystemAvailable()) {
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REMOTE_REPOSITORY_UNAVAILABLE", null, null);
            }
            PIHMCStringDataBean pIHMCStringDataBean = new PIHMCStringDataBean(this.validKeys);
            pIHMCStringDataBean.setKeyValue(LIC_TYPE_FORMAT, string);
            if (!pIUpdateableComponent.isUpdatingEnabled()) {
                pIHMCStringDataBean.setKeyValue(MGMT_STATUS_FORMAT, "Disabled");
                pIHMCStringDataBean.setKeyValue(REASON_FORMAT, pIUpdateableComponent.getUpdatingDisabledReason().toString());
            } else {
                pIHMCStringDataBean.setKeyValue(MGMT_STATUS_FORMAT, "Enabled");
                pIHMCStringDataBean.setKeyValue(REASON_FORMAT, "");
            }
            if (n == -1) {
                pIHMCStringDataBean.setKeyValue(ACT_LEVEL_FORMAT, "None");
            } else {
                pIHMCStringDataBean.setKeyValue(ACT_LEVEL_FORMAT, String.valueOf(n));
            }
            if (n2 == -1) {
                pIHMCStringDataBean.setKeyValue(INST_LEVEL_FORMAT, "None");
            } else {
                pIHMCStringDataBean.setKeyValue(INST_LEVEL_FORMAT, String.valueOf(n2));
            }
            if (n3 == -1) {
                pIHMCStringDataBean.setKeyValue(ACCEPTED_LEVEL_FORMAT, "None");
            } else {
                pIHMCStringDataBean.setKeyValue(ACCEPTED_LEVEL_FORMAT, String.valueOf(n3));
            }
            if (string3 == null) {
                string3 = "None";
            }
            pIHMCStringDataBean.setKeyValue(ECNUMBER_FORMAT, string3);
            if (string4 == null) {
                string4 = "None";
            }
            pIHMCStringDataBean.setKeyValue(MTMS_FORMAT, string4);
            if (this.checkRepos) {
                if (n4 == -1) {
                    pIHMCStringDataBean.setKeyValue(CONC_RETR_LEVEL_FORMAT, "None");
                } else {
                    pIHMCStringDataBean.setKeyValue(CONC_RETR_LEVEL_FORMAT, String.valueOf(n4));
                }
                if (n5 == -1) {
                    pIHMCStringDataBean.setKeyValue(DISR_RETR_LEVEL_FORMAT, "None");
                } else {
                    pIHMCStringDataBean.setKeyValue(DISR_RETR_LEVEL_FORMAT, String.valueOf(n5));
                }
            }
            this.taskletOutput.addElement(pIHMCStringDataBean);
        }
    }

    public void performCommand() throws Exception {
        this.updatesOwner = null;
        this.compList = null;
        RepositoryItem repositoryItem = null;
        MediaServicesUtil mediaServicesUtil = null;
        MediaDevice mediaDevice = null;
        String string = new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "MANAGED_SYSTEM").toString();
        String string2 = new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "POWER_SUBSYSTEM").toString();
        this.initializeClients();
        PICec pICec = new PICec(this.hcc.getObjectPath());
        try {
            this.updatesOwner = new PIUpdatesOwner(pICec);
            PIUpdater pIUpdater = (PIUpdater)this.updatesOwner.getUpdaterInstance();
            if (this.checkRepos) {
                repositoryItem = new RepositoryItem(this.reposType);
                if (this.reposType == 4) {
                    repositoryItem.setLocation(this.hostname);
                    repositoryItem.setFTPUSER(this.username);
                    repositoryItem.setFTPPW(this.password);
                    if (this.directory == null) {
                        this.directory = BaseFileControl.getFilePath((String)"iqzmsupd.dat");
                    }
                    repositoryItem.setDirPath(this.directory);
                } else if (this.reposType == 1) {
                    if (this.mountpoint) {
                        repositoryItem.setLocation(this.directory);
                    } else {
                        mediaServicesUtil = new MediaServicesUtil(null);
                        mediaDevice = PIUpdLic.prepareDVD(mediaServicesUtil, repositoryItem, "lslic");
                    }
                }
                this.compList = this.updatesOwner.getUpdateableComponents(repositoryItem, false);
            } else {
                this.compList = this.updatesOwner.getUpdateableComponents();
            }
            if (this.targetCEC) {
                this.checkLIC(string);
            }
            if (this.targetPower) {
                this.checkLIC(string2);
            }
            if (mediaServicesUtil != null) {
                PIUpdLic.releaseDVD(mediaServicesUtil);
            }
        }
        catch (Exception exception) {
            if (mediaServicesUtil != null) {
                PIUpdLic.releaseDVD(mediaServicesUtil);
            }
            throw exception;
        }
    }

    public void mapParameters(HashMap hashMap, PrintStream printStream) throws PIHscClientException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        this.targetCEC = false;
        this.targetPower = false;
        this.reposType = -1;
        this.managedSystem = null;
        this.mountpoint = false;
        string = (String)hashMap.get("-t");
        string2 = (String)hashMap.get("-m");
        string3 = (String)hashMap.get("-r");
        this.hostname = (String)hashMap.get("-h");
        this.username = (String)hashMap.get("-u");
        this.directory = (String)hashMap.get("-d");
        this.password = (String)hashMap.get("--passwd");
        this.m_format = (String)hashMap.get("-F");
        string4 = (String)hashMap.get("--header");
        if (string == null) {
            String[] stringArray = new String[]{"-t"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if ((string = string.trim()).equals(CPC_PARAM) || string.equals(SYS_PARAM)) {
            this.targetCEC = true;
        } else if (string.equals(POWER_PARAM)) {
            this.targetPower = true;
        } else if (string.equals(CPCPOWER_PARAM) || string.equals(SYSPOWER_PARAM)) {
            this.targetCEC = true;
            this.targetPower = true;
        } else {
            String[] stringArray = new String[]{"-t"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray, null);
        }
        if (string2 == null) {
            String[] stringArray = new String[]{"-m"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        this.managedSystem = string2.trim();
        if (string3 != null) {
            if ((string3 = string3.trim()).equals(RETAIN_PARAM)) {
                this.reposType = 5;
            } else if (string3.equals(WEBSITE_PARAM)) {
                this.reposType = 0;
            } else if (string3.equals(FTP_PARAM)) {
                this.reposType = 4;
            } else if (string3.equals(DVD_PARAM)) {
                this.reposType = 1;
            } else if (string3.equals(DISK_PARAM)) {
                this.reposType = 3;
            } else if (string3.equals(MOUNTPOINT_PARAM)) {
                this.mountpoint = true;
                this.reposType = 1;
            } else {
                String[] stringArray = new String[]{"-r"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray, null);
            }
            this.checkRepos = true;
            this.validKeys = reposKeys;
        } else {
            this.checkRepos = false;
            this.validKeys = noReposKeys;
        }
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, this.validKeys, this.validKeys.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            this.actualKeys = PICmdOutputUtils.checkKeys(this.validKeys, this.m_format, this.m_delimiter);
        } else {
            this.actualKeys = this.validKeys;
        }
        if (string4 != null) {
            if (this.m_format == null) {
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_HEADER_PARM", null, null);
            }
            if (string4.trim().length() != 0) {
                String[] stringArray = new String[]{"--header"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray, null);
            }
            this.m_header = true;
        }
        if (this.mountpoint) {
            if (this.directory == null) {
                String[] stringArray = new String[]{"-d"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
            this.directory = this.directory.trim();
            File file = new File(this.directory);
            if (!file.isDirectory()) {
                String[] stringArray = new String[]{"-d " + this.directory};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM", stringArray, null);
            }
        } else if (this.reposType == 4) {
            if (this.hostname == null) {
                String[] stringArray = new String[]{"-h"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
            this.hostname = this.hostname.trim();
            if (this.username == null) {
                String[] stringArray = new String[]{"-u"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
            this.username = this.username.trim();
            if (this.directory != null) {
                this.directory = this.directory.trim();
            }
            if (this.password != null) {
                this.password = this.password.trim();
            } else {
                this.readPassword(printStream);
            }
        } else {
            PIHMCCommandUtils.checkInvalidCombination(hashMap, FTP_PARAMS);
        }
    }

    public void printResults(int n, PrintStream printStream) {
        if (n != 0) {
            Enumeration enumeration = this.taskletOutput.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                printStream.println(string);
            }
            return;
        }
        PICmdOutputUtils.printResults(printStream, false, this.taskletOutput.elements(), this.actualKeys, this.m_delimiter, this.m_header, this.m_format == null);
    }

    public static void printHelp(PrintStream printStream) {
        String string = "Usage: lslic -m <managed system>\n             -t sys | power | syspower\n             [-r ibmretain | ibmwebsite | ftp | dvd | disk | mountpoint]\n             [-h <hostname>]\n             [-u <userid>]\n             [--passwd <password>]\n             [-d <directory>]\n             [-F [<attribute names>]]\n             [--header]\n             [--help]\n\nList Licensed Internal Code (LIC) levels installed, activated and accepted\non a managed system.  This command will optionally display LIC levels that\nare available to be retrieved from a specified repository.\n\n    -m <managed system>    - The managed system's name.\n    -t <type>              - The type(s) of LIC levels to display:\n                               sys -      Managed System LIC levels only.\n                               power -    Power LIC levels only.\n                               syspower - Managed System and Power LIC levels.\n    -r <repository>        - The repository which should be queried for\n                             LIC levels that are available to be\n                             retrieved:\n                               ibmretain  - IBM Support System (RETAIN)\n                               ibmwebsite - IBM service web site\n                               ftp        - specified FTP site\n                               dvd        - DVD drive\n                               disk       - HMC harddisk fixpack staging area\n                               mountpoint - specified mountpoint\n    -h <hostname>          - the hostname of the FTP server to connect to\n    -u <user name>         - the user name to use to log in to the FTP server\n    --passwd <password>    - the password to use to log in to the FTP server.\n                             If this parameter is omitted, then you will be\n                             prompted for the password.\n    -d <directory>         - the mountpoint location or the directory to use on\n                             the FTP server.  If this parameter is omitted for\n                             FTP, the default HMC hard drive location will be\n                             used.\n    -F [<attribute names>] - delimiter-separated list of the names of the\n                             attributes to be listed for each LIC type.\n                             If no attribute names are specified, then all\n                             attributes will be listed.\n    --header               - prints a header of attribute names when -F is\n                             also specified\n    --help                 - prints this help";
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "LSLIC_HELP_GA2", string, null));
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        int n = 0;
        PIHscUtil.initHscUtil(3);
        PILsLic pILsLic = new PILsLic();
        try {
            String string2 = null;
            if (0 == stringArray.length) {
                PILsLic.printHelp(System.out);
                bl = true;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = stringArray[i];
                arrayList.add(string2);
                if (!string2.equals("--help")) continue;
                PILsLic.printHelp(System.out);
                bl = true;
                break;
            }
            if (!bl) {
                HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pILsLic.m_validParms);
                pILsLic.mapParameters(hashMap, System.out);
                n = pILsLic.invokeViaTasklet();
                pILsLic.printResults(n, System.out);
            }
        }
        catch (PIHscClientException pIHscClientException) {
            if ("8000".equals(pIHscClientException.getHscExId())) {
                System.out.println(pIHscClientException.getMessage());
            } else {
                pIHscClientException.printStackTrace(System.out);
                string = pIHscClientException.getMessage();
                if (string == null) {
                    string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "COMMAND_LINE_ERROR");
                }
                System.out.println(string);
            }
            n = 8;
        }
        catch (HSCException hSCException) {
            hSCException.printStackTrace();
            string = hSCException.getMessage();
            if (string == null) {
                string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "COMMAND_LINE_ERROR");
            }
            System.out.println(string);
            n = 8;
        }
        System.exit(n);
    }
}

